#include <ESP8266WiFi.h>       // Bibliothèque Wi-Fi ESP8266
#include <OneWire.h>           // Bibliothèque 1-Wire
#include <DallasTemperature.h> // Bibliothèque Dallas
#define ONE_WIRE_BUS 2         // Broche DS18B20 - GPIO 2
#define SERVER_PORT  80        // Port HTTP
 
OneWire oneWire(ONE_WIRE_BUS);       // Initialisation one wire
DallasTemperature sensors(&oneWire); // Transmet la référence one wire à Dallas
 
String apiKey = "D3YTWQFJPZQJZSRY";        // Clé API ThingSpeak
const char* ssid = "Highli";               // SSID
const char* password = "SeCronLap0_78";    // Mot de passe
const char* server = "api.thingspeak.com"; // Serveur ThingSpeak
 
WiFiClient client; // Crée un client WiFi
 
void setup() {                
  Serial.begin(115200);
  sensors.begin();    // Démarrage de la bibliothèque Dallas
  delay(10);
  WiFi.begin(ssid, password); // Démarrage du client WiFi
 
  Serial.println("\n\n");
  Serial.print("Connexion a: ");
  Serial.println(ssid);
    
  // Interrogation del'état
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println();
  Serial.println("WiFi connecte");
  Serial.print("Adresse IP: ");
  Serial.println(WiFi.localIP());
}
 
void loop() {
  float temperature; // Enregistre la valeur de la température
  sensors.requestTemperatures(); // Demande la mesure de la température
  temperature = sensors.getTempCByIndex(0);
  // Affichage du textepour le capteur #1
  Serial.print("Temperature Capteur #1: ");
  Serial.print(temperature); //Affichage de la température mesurée par le capteur #1
  Serial.println(" deg. Celsius");
  if (client.connect(server, SERVER_PORT)) {  
  String post = apiKey;
         post +="&field1=";
         post += String(temperature);
         post += "\r\n\r\n";
 
     client.print("POST /update HTTP/1.1\n"); 
     client.print("Host: api.thingspeak.com\n"); 
     client.print("Connection: close\n"); 
     client.print("X-THINGSPEAKAPIKEY: " + apiKey + "\n"); 
     client.print("Content-Type: application/x-www-form-urlencoded\n"); 
     client.print("Content-Length: "); 
     client.print(post.length()); 
     client.print("\n\n"); 
     client.print(post);       
 
     Serial.print("Temperature: ");
     Serial.print(temperature);
     Serial.println("deg. Celsius transmise vers Thingspeak");
     Serial.println(post);
  }
  client.stop(); // Fermeture dela connexion client WiFi
   
  Serial.println("En attente...");    
  delay(20000); // PAuse de 20 secondes
}

